package jamezo97.clonecraft.dna;

import jamezo97.clonecraft.entity.EntityModifiable;
import net.minecraft.entity.CloneCraftEntityAccessor;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityWolf;

public class GeneSmall extends Gene {

	public GeneSmall(int id) {
		super(id);
	}

	@Override
	public String getName() {
		return "Small";
	}

	@Override
	public int getMaxAmount() {
		return 2;
	}

	@Override
	public String getStringValue(int amount) {
		return amount + "x Size Reduction";
	}

	@Override
	public int getColour() {
		return 0xffa8c284;
	}

	@Override
	public Class[] getEntityClassesWithGene() {
		return new Class[]{
				EntityChicken.class, EntitySlime.class, EntityWolf.class
		};
	}

	@Override
	public void onUpdate(EntityLivingBase entity, IModifiable mod, int level) {
		float scale = 1.0f/((float)level);
		if(mod.hasGene(Gene.large)){
			scale = scale * ((float)mod.getGeneStrength(Gene.large));
		}
		mod.setGeneScaling(scale);


		float width = mod.getBaseXSize();

		float height = mod.getBaseYSize();
		
		float yOffset = mod.getBaseYOffset();
		if(mod.shouldApplySizeChange()){
			width *= scale;
			height *= scale;
			yOffset *= scale;
			entity.stepHeight = mod.getBaseStepHeight() * scale;
		}
//		entity.yOffset = yOffset;
		if(entity.width != width || entity.height != height){
			CloneCraftEntityAccessor.setSize(entity, width, height);
		}
	}

	@Override
	public void addGeneEffect(EntityLivingBase entity, int level) {
	}

}
